Function SetupAudio()
    audioOutput = CreateObject("roAssociativeArray")
    audioOutput["HDMI"] = CreateObject("roAudioOutput", "HDMI")
    audioOutput["Analog"] = CreateObject("roAudioOutput", "Analog")
    audioOutput["SPDIF"] = CreateObject("roAudioOutput", "SPDIF")
    audioOutput["USB"] = CreateObject("roAudioOutput", "USB")
    audioOutput["NONE"] = CreateObject("roAudioOutput", "NONE")

    ' Setup routing for audio routing
    audioConfiguration = CreateObject("roAudioConfiguration")
    audioConfiguration.ConfigureAudio({ mode: "prerouted", autolevel: "off", pcmonly: "true", srcrate: "48000" })

    print "SetupAudio completed"
    return audioOutput
End Function

Function SetupDebug()
    debugRegistrySection = CreateObject("roRegistrySection", "debug")

    if debugRegistrySection.Read("enabled") = "1" then

        ' Native Debug for firmware higher then 8.5
        deviceInfo = CreateObject("roDeviceInfo")
        if deviceInfo.FirmwareIsAtLeast("8.5.31") then
            registryHtmlSection = CreateObject("roRegistrySection", "html")
            registryHtmlSection.write("enable_web_inspector", "1")
            registryHtmlSection.flush()
        endif

        networkingRegistry = CreateObject("roRegistrySection", "networking")
        ' access to BrightSign web interface
        networkingRegistry.write("http_server", "80")
        networkingRegistry.write("ssh","22")
        networkingRegistry.write("telnet","23")
        networkingRegistry.flush()
    else 
        ' Native Debug for firmware higher then 8.5
        deviceInfo = CreateObject("roDeviceInfo")
        if deviceInfo.FirmwareIsAtLeast("8.5.31") then
            registryHtmlSection = CreateObject("roRegistrySection", "html")
            registryHtmlSection.write("enable_web_inspector", "0")
            registryHtmlSection.flush()
        endif

        networkingRegistry = CreateObject("roRegistrySection", "networking")
        ' access to BrightSign web interface
        networkingRegistry.delete("http_server")
        networkingRegistry.delete("ssh")
        networkingRegistry.delete("telnet")
        networkingRegistry.flush()
    end if

    print "SetupDebug completed"
    return debugRegistrySection
End Function

Function SetupVideoMode()
    videoModeProvider = CreateObject("roVideoMode")
    videoModeProvider.SetGraphicsZOrder("back")
    videoModeProvider.SetBackgroundColor(&h18182c)

    print "SetupVideoMode completed"
    return videoModeProvider
End Function

Function GetSupportedVideoModes(videoModeProvider)
    allModes = videoModeProvider.GetAvailableModes()
    supportedModes = CreateObject("roArray", 0, true)
    includedModes = CreateObject("roAssociativeArray")
    While allModes.IsNext()
        mode = allModes.Next()
        modeKey = CreateObject("roString")
        width = mode["width"].ToStr()
        height = mode["height"].ToStr()
        framerate = mode["framerate"].ToStr()
        modeKey.AppendString(width, width.Len())
        modeKey.AppendString("x", 1)
        modeKey.AppendString(height, height.Len())
        modeKey.AppendString("@", 1)
        modeKey.AppendString(framerate, framerate.Len())
        ' Videos in PORTRAIT orientation can not be played in interlaced modes
        if mode.interlaced = false and not(includedModes.DoesExist(modeKey)) then
            includedModes.AddReplace(modeKey, modeKey)
            supportedModes.Push(mode)
        endif
    End While
    print "supportedVideoModes";FormatJson(supportedModes, 1)
    return supportedModes
End Function

Function IsMounted(path as String)
    return CreateObject("roStorageHotplug").GetStorageStatus(path).mounted
End Function

Function GetFirstAvaliableStorageUnit()
    destinationPaths = ["SSD:", "SD:", "USB1:"]
    di = CreateObject("roDeviceInfo")
    family = lcase(di.GetFamily())
    if family = "thor" then
        destinationPaths.push("FLASH:")
        availableDestinations = CreateObject("roArray", 4, false)
    else
        availableDestinations = CreateObject("roArray", 3, false)
    end if
    for each destination in destinationPaths
        if IsMounted(destination) then
            availableDestinations.Push(destination)
        end if
    next
    return availableDestinations[0]
End function

Function GetCurrentTransform(screenRegistrySection)
    orientation = screenRegistrySection.Read("orientation")
    if orientation = "LANDSCAPE" then
        return "identity"
    endif
    if orientation = "PORTRAIT" then
        return "rot90"
    endif
    if orientation = "PORTRAIT_FLIPPED" then
        return "rot270"
    endif
    return "identity"
End Function

Function GetCurrentHWZSettings()
    hwzRegistrySection = CreateObject("roRegistrySection", "hardware_acceleration")
    hwzValue = hwzRegistrySection.Read("enabled")

    ' When value does not exists in hwzRegistry, it should initialize to "on"
    if hwzValue = "" then
        hwzRegistrySection.Write("enabled", "1")
        hwzRegistrySection.Flush()
        return "on"
    end if

    if hwzValue = "1" then
        return "on"
    else
        return "off"
    end if
End Function

Function GetHtmlWidgetSecuritySettings(parameter)
    htmlWidgetSecuritySettings = CreateObject("roRegistrySection", "htmlWidgetSecurity")
    settingValue = htmlWidgetSecuritySettings.Read(parameter)

    if settingValue = "enabled" then
        return true
    else if settingValue = "disabled" then
        return false
    else
        ' default values
        if parameter = "websecurity" then
            return false
        end if

        if parameter = "camera_enabled" then
            return true
        end if

        if parameter = "insecure_https_enabled" then
            return true
        end if

    end if

    return false

End Function

Function GetHtmlWidgetSettings(parameter)
    htmlWidgetSettings = CreateObject("roRegistrySection", "htmlWidgetSettings")
    settingValue = htmlWidgetSettings.Read(parameter)

    if settingValue = "enabled" then
        return true
    else if settingValue = "disabled" then
        return false
    else
        ' default values
        if parameter = "mouse_enabled" then
            return true
        end if

        if parameter = "focus_enabled" then
            return true
        end if

        if parameter = "pinch_to_zoom_enabled" then
            return true
        end if

        if parameter = "scrollbar_enabled" then
            return true
        end if

    end if

    return false

End Function

Function SetupHtmlWidget(msgPort, screenRegistrySection, screenRectangle, debugRegistrySection, htmlFileName, organizationUid, browserWindows)

    currentTransform = GetCurrentTransform(screenRegistrySection)
    firstAvaiableStorage = GetFirstAvaliableStorageUnit()
    hwzSettings = GetCurrentHWZSettings()

    mouseEnabledFlag = GetHtmlWidgetSettings("mouse_enabled")
    focusEnabledFlag = GetHtmlWidgetSettings("focus_enabled")
    pinchToZoomEnabledFlag = GetHtmlWidgetSettings("pinch_to_zoom_enabled")
    scrollbarEnabledFlag = GetHtmlWidgetSettings("scrollbar_enabled")

    websecurityFlag = GetHtmlWidgetSecuritySettings("websecurity")
    cameraEnabledFlag = GetHtmlWidgetSecuritySettings("camera_enabled")
    insecureHttpsFlag = GetHtmlWidgetSecuritySettings("insecure_https_enabled")

    config = {
        nodejs_enabled: true,
        brightsign_js_objects_enabled: true,
        mouse_enabled: mouseEnabledFlag,
        focus_enabled: focusEnabledFlag,
        javascript_enabled: true,
        url: "file:///" + htmlFileName,
        storage_path: firstAvaiableStorage,
        storage_quota: 1073741824,
        transform: currentTransform,
        hwz_default: hwzSettings,
        pinch_to_zoom_enabled: pinchToZoomEnabledFlag,
        scrollbar_enabled: scrollbarEnabledFlag,
        security_params: {
            websecurity: websecurityFlag,
            camera_enabled: cameraEnabledFlag,
            insecure_https_enabled: insecureHttpsFlag
        }
        'port: msgPort ' Doesn't work in 6.2 FW. Used this htmlWidget.SetPort(msgPort)
    }

    ' adding both for backwards compatibility
    if debugRegistrySection.Read("enabled") = "1" then
        debugPort = 3000
        config["inspector_server"] = {
            port: debugPort
        }
    endif

    ' ever since BrightOS 8.2 there is a mandatory requirement to disable web security by this option
    ' With BOS 8.2 and later (Chromium69 and later), several new CORS checks have been added: 
    ' security_params.websecurity or enableSecurity(false) do not disable all these checks.
    htmlRegistrySection = CreateObject("roRegistrySection", "html")
    disableWebSecurity = htmlRegistrySection.read("disable-web-security")
    if disableWebSecurity <> "1" then
        htmlRegistrySection.write("disable-web-security", "1")
        htmlRegistrySection.flush()
    endif

    ' using htmlWidget to limit possible conflict with 3rd party htmlWidget created in custom.brs
    htmlWidget = CreateObject("roHtmlWidget", screenRectangle, config)
    htmlWidget.SetPort(msgPort)

    proxyServer = GetProxyServer()
    proxyServerBypass = GetProxyBypass()

    htmlWidget.SetProxy(proxyServer)
    htmlWidget.SetProxyBypass(proxyServerBypass)
    
    ' wait for the ready message from html widget
    WaitHtmlWidgetReady(msgPort)
    htmlWidget.Show()

    htmlWidget.PostJSMessage({
        type: "ready",
        organization_uid: organizationUid
    })

    print "SetupHtmlWidget completed"
    browserWindows.AddReplace("main", htmlWidget)
    return htmlWidget
End Function

Sub WaitHtmlWidgetReady(msgPort)
    while true
        msg = Wait(0, msgPort)
        if type(msg) = "roHtmlWidgetEvent" then
            eventData = msg.GetData()
            if type(eventData) = "roAssociativeArray" and type(eventData.reason) = "roString" then
                if eventData.reason = "message" and eventData.message.type = "ready" then
                    print "htmlWidget ready"
                    exit while
                endif
            endif
        endif
    end while
End Sub

Function GetProxyServer()
    ' These Proxy helpers are used to configure networking of the roHtmlWidget
    ' roHtmlWidget ignores the general settings and configuration of roNetworkConfiguration

    ' Currently we hardcode proxy setup only for Ethernet as it's unclear how to get "current network" (eth, wifi)
    ' 0 = lan0
    ' 1 = wlan0
    proxyServer = false
    networkConfigurationEthernet = CreateObject("roNetworkConfiguration", 0)
    if type(networkConfigurationEthernet) = "roNetworkConfiguration" then
        proxyServer = networkConfigurationEthernet.getProxy()
    end if
    networkConfigurationWifi = CreateObject("roNetworkConfiguration", 1)
    if type(networkConfigurationWifi) = "roNetworkConfiguration" then
        proxyServer = networkConfigurationWifi.getProxy()
    end if

    return proxyServer
End Function

Function GetProxyBypass()
    ' These Proxy helpers are used to configure networking of the roHtmlWidget
    ' roHtmlWidget ignores the general settings and configuration of roNetworkConfiguration

    ' Currently we hardcode proxy setup only for Ethernet as it's unclear how to get "current network" (eth, wifi)
    ' 0 = lan0
    ' 1 = wlan0
    proxyServerBypass = false
    networkConfigurationEthernet = CreateObject("roNetworkConfiguration", 0)
    if type(networkConfigurationEthernet) = "roNetworkConfiguration" then
        proxyServerBypass = networkConfigurationEthernet.GetProxyBypass()
    end if
    networkConfigurationWifi = CreateObject("roNetworkConfiguration", 1)
    if type(networkConfigurationWifi) = "roNetworkConfiguration" then
        proxyServerBypass = networkConfigurationWifi.GetProxyBypass()
    end if

    return proxyServerBypass
End Function

Function CollectGarbageAndReboot(uptimeMultiplier)
    uptime = UpTime(1)
    timeToCollectGarbage = 3600 * uptimeMultiplier
    shouldWeCollectGarbage = uptime - timeToCollectGarbage
    if shouldWeCollectGarbage > 1 then
        uptimeMultiplier = uptimeMultiplier + 1
        RunGarbageCollector()
    end if
    
    ' 87000 seconds is over 24 hours
    if uptime > 87000 then
        RebootSystem()
    end if

    uptime = invalid
    timeToCollectGarbage = invalid
    shouldWeCollectGarbage = invalid

    return uptimeMultiplier
End Function
