Sub ProcessTouchEvent(msg, browserWindows, screenRegistrySection)
    orientation = screenRegistrySection.Read("orientation")
    resolution = GetCurrentResolution(screenRegistrySection)
    touchEvent = CreateObject("roAssociativeArray")
    touchEvent["type"] = "touch_event"
    if orientation = "PORTRAIT" then
        touchEvent["x"] = resolution.height - msg.GetY()
        touchEvent["y"] = msg.GetX()
    else if orientation = "PORTRAIT_FLIPPED" then
        touchEvent["x"] = msg.GetY()
        touchEvent["y"] = resolution.width - msg.GetX()
    else
        touchEvent["x"] = msg.GetX()
        touchEvent["y"] = msg.GetY()
    end if

    htmlWidget = browserWindows.Lookup("main")
    browserWidget = browserWindows.Lookup("browser")
    if browserWidget <> invalid then
        browserWidget.PostJSMessage(touchEvent)
    end if

    htmlWidget.PostJSMessage(touchEvent)

    ' Set variables to invalid to allow garbage collection
    touchEvent = invalid
End Sub

Sub ProcessVideoEvent(msg, htmlWidget, videoPlayers, videoMetadata)
    videoEvent = CreateObject("roAssociativeArray")
    videoEvent["type"] = "video_event"
    videoEvent["key"] = msg.GetUserData()
    videoEvent["eventType"] = msg.GetInt()
    videoPlayerKey = videoEvent.key
    videoPlayer = videoPlayers.Lookup(videoEvent.key)
    print "videoEvent ";msg.GetInt();" data ";msg.GetData();" videoEvent ";videoEvent.key
    ' Video events from src/Video/VideoEventType.ts
    ' PAUSED = 2
    ' PLAYING = 3,
    ' ENDED = 8,
    ' TIMECODE_HIT = 12,
    ' MEDIA_ERROR = 16,
    ' ERROR = 30,
    metadata = videoMetadata.Lookup(videoPlayerKey)

    ' Faking Pause event because BrightSign does not offer native message/code
    ' Used only after calling sos.video.pause() to resolve the JS promise
    if msg.GetInt() = 12 and msg.GetData() = 2 then
            if metadata.invocationUid <> invalid then
                ' Resolve JS API promise on sos.video.pause()
                InvokeJSMessage(htmlWidget, metadata.invocationUid, true, invalid)
                ' invalidating invocationUid
                SetMetadataInvocationUid(videoMetadata, videoPlayerKey, metadata.looped, invalid)
            end if
    else if msg.GetInt() = 3 then
        if metadata.invocationUid <> invalid then
            if metadata.type = "video" then
                SetVideoMetadata(videoPlayers, videoMetadata, videoPlayerKey, metadata.looped)
                AppendEndedEvent(videoPlayer)
            end if

            ' Resolve JS API promise on sos.video.play() or sos.video.resume()
            InvokeJSMessage(htmlWidget, metadata.invocationUid, true, invalid)
            ' invalidating invocationUid
            SetMetadataInvocationUid(videoMetadata, videoPlayerKey, metadata.looped, invalid)
            ' reseting status of timecode ended flag for looped playback use case
            SetVideoMetadataEnded(videoMetadata, videoPlayerKey, false)
        end if
    else if msg.GetInt() = 8 then
        ' in case we loop a sigle video, we need to do Pause immediately, otherwise the video
        ' visually slips to 00:00:00 frame and that is not acceptable
        videoPlayer.Pause()

        ' Video must play for no less than specified period minus 1000ms otherwise media error will be thrown
        if metadata.type = "video" AND metadata.stopped = false AND metadata.timer.TotalMilliseconds() < (metadata.duration - 1000) then
            videoEvent["eventType"] = 16
        end if

        ' single video loop logic is triggered only on videos that are marked as Looped by video.resume() event
        if metadata.type = "video" AND metadata.looped = true then
                videoDuration = videoPlayer.GetDuration()
                ' There is a lot to play, event 8 triggered by loop restart, mark is as looping video and continue playback
                videoPlayer.Seek(0)
                videoPlayer.Resume()
                videoPlayer.ClearEvents()
                ' Set custom end event a milisecond before the actual end of the video
                isLooped = false
                SetVideoMetadata(videoPlayers, videoMetadata, videoPlayerKey, isLooped)
                videoPlayer.AddEvent(8, videoDuration - 1000)
                videoEvent["eventType"] = 3
        else
                videoEvent["eventType"] = 8
        end if
    ' When video loop mode enabled BS doesn't send ENDED (8) event automatically so we add Timecode event at moment
    ' of planned video end and such event is here mapped to ENDED (8) event
    else if msg.GetInt() = 12 and msg.GetData() = 8 then
        videoDuration = videoPlayer.GetDuration()
        videoPosition = videoPlayer.GetPlaybackPosition()
        remainingTime = videoDuration - videoPosition

        ' to properly capture the end of the video we are using progressive tracking of remaining playback time
        ' as this event is triggered multiple times due to time lapse (serial event processing can get delayed) we need to
        ' add this specific metadata.ended flag to prevent pausing the video repeatedly
        if remainingTime < 150 AND metadata.ended <> true then
            videoPlayer.Pause()
            videoEvent["eventType"] = 8
            SetVideoMetadataEnded(videoMetadata, videoPlayerKey, true)
        else
            eventTime = videoPosition + (remainingTime*0.6)
            ' prevents adding multiple events in case of slow players
            ' this event is triggered every 10ms it lapses /is behind/ the actual time
            videoPlayer.ClearEvents()
            videoPlayer.AddEvent(8, eventTime)
            videoEvent = invalid
            sleep(1)
        end if
    end if

    if videoEvent <> invalid then
        htmlWidget.PostJSMessage(videoEvent)
    end if

    ' Set variables to invalid to allow garbage collection
    videoEvent = invalid
End Sub

Sub ProcessHardwareEvent(data, htmlWidget, serialPorts)
    hardwareEvent = CreateObject("roAssociativeArray")
    hardwareEvent["type"] = "hardware_event"
    hardwareEvent["data"] = data
    htmlWidget.PostJSMessage(hardwareEvent)

    ' Set variables to invalid to allow garbage collection
    hardwareEvent = invalid
End Sub

Sub ProcessHtmlWidgetEvent(msg, msgPort, browserWindows, videoModeProvider, supportedVideoModes, systemTime, screenRegistrySection, videoPlayers, videoMetadata, serialPorts, onScreenKeyboardObject)
    eventData = msg.GetData()
    print "message = ";eventData.message

    htmlWidget = browserWindows.Lookup("main")
    browserWidget = browserWindows.Lookup("browser")

    if type(eventData) = "roAssociativeArray" and type(eventData.reason) = "roString" then
        response = CreateObject("roAssociativeArray")

        ' This flag is used to skip response in case the message triggers async task
        ' typically used for video events
        defferedResponse = false

        ' Used to handle browser links with "target=_blank" attribute
        if eventData.reason = "new-window-request" then
            activeBrowserWidget = browserWindows.Lookup("browser")
            if activeBrowserWidget <> invalid then
                    ' Get correct resolution and size for new browser
                    browser_x = browserWindows.Lookup("browser_x")
                    browser_y = browserWindows.Lookup("browser_y")
                    browser_width = browserWindows.Lookup("browser_width")
                    browser_height = browserWindows.Lookup("browser_height")
                    browserWidget = SetupBrowserWidget(msgPort, screenRegistrySection, eventData.uri, browser_x, browser_y, browser_width, browser_height, browserWindows)
                    browser_x = invalid
                    browser_y = invalid
                    browser_width = invalid
                    browser_height = invalid
            end if
        end if

        if eventData.reason = "download-request" then
            if IsPdfFileOnUrl(eventData.mime_type, eventData.url) then
            ' PDF browser works only in browser, not in the main window
                activeBrowserWidget = browserWindows.Lookup("browser")
                if activeBrowserWidget <> invalid then
                        ' Get correct resolution and size for new browser
                        browser_x = browserWindows.Lookup("browser_x")
                        browser_y = browserWindows.Lookup("browser_y")
                        browser_width = browserWindows.Lookup("browser_width")
                        browser_height = browserWindows.Lookup("browser_height")
                        pdfLink = "file:///pdf-reader/web/viewer.html?file=" + eventData.url
                        browserWidget = SetupBrowserWidget(msgPort, screenRegistrySection, pdfLink, browser_x, browser_y, browser_width, browser_height, browserWindows)
                        browser_x = invalid
                        browser_y = invalid
                        browser_width = invalid
                        browser_height = invalid
                        pdfLink = invalid
                end if
            end if
        end if

        if eventData.reason = "message" then
            if eventData.message.type = "application.restart" then
                RestartApplication()
                'RestartScript() 'soft restart of application
                response["succeeded"] = true
            end if
            if eventData.message.type = "screen.set_video_mode" then
                response["succeeded"] = SaveVideoModeIfSupported(screenRegistrySection, supportedVideoModes, eventData.message.width, eventData.message.height, eventData.message.framerate)
            end if
            if eventData.message.type = "video.init_player" then
                videoPlayerKey = eventData.message.key
                videoPlayer = CreateObject("roVideoPlayer")
                videoPlayer.SetPort(msgPort)
                videoPlayer.SetUserData(videoPlayerKey)
                videoPlayer.SetViewMode("LetterboxedAndCentered")
                videoPlayers.AddReplace(videoPlayerKey, videoPlayer)
                response["succeeded"] = true
            end if
            if eventData.message.type = "video.prepare" then
                videoPlayerKey = eventData.message.key
                videoPlayer = videoPlayers.Lookup(videoPlayerKey)
                PrepareMedia(screenRegistrySection, videoModeProvider, videoPlayer, eventData)
                SetMetadataType(videoMetadata, videoPlayerKey, eventData.message.vtype)
                if eventData.message.vtype = "stream" then
                    streamUri = eventData.message.uri
                    PrepareStream(videoPlayer, streamUri)
                end if
                ' After Prepare we do a lot of getDuration() which only works once the video is fully loaded
                ' It's neccessary to wait a bit here
                sleep(10)
                response["succeeded"] = true
            end if
            if eventData.message.type = "video.play" then
                videoPlayerKey = eventData.message.key
                videoPlayer = videoPlayers.Lookup(videoPlayerKey)

                ' default state of video player is not looped
                ' it's set to looped only if applet calls play on the completed video
                ' in that case, video.resume() is called, instead of video.play() and looped status is changed to true
                isLooped = false

                if eventData.message.vtype = "video" then
                    videoFilePath = eventData.message.filePath
                    videoVolume = strtoi(eventData.message.volume)

                    ' Because of complex state management of video players and the fact
                    ' that videoPlayer.PreloadFile is triggering stop on any video
                    ' we need to move the file preloading here.
                    ' Fortunately it does not create any gap or performance issue
                    ' because we prepare the environment for playback upfront
                    ' in the prepare method.
                    PlayVideo(videoPlayer, videoFilePath, videoVolume)
                else if eventData.message.vtype = "stream" then
                    streamUri = eventData.message.uri
                    PlayStream(videoPlayer, streamUri)
                else if eventData.message.vtype = "hdmi" then
                    PlayHDMI(videoPlayer)
                end if
                SetMetadataInvocationUid(videoMetadata, videoPlayerKey, isLooped, eventData.message.invocationUid)
                defferedResponse = true
            end if
            if eventData.message.type = "video.prepare_and_play" then
                ' This method covers playback on LS/HD models that only have 1 video player
                ' All video playback is using this method only
                ' We need to do a complete video life cycle here
                videoPlayerKey = eventData.message.key
                videoPlayer = videoPlayers.Lookup(videoPlayerKey)
                PrepareMedia(screenRegistrySection, videoModeProvider, videoPlayer, eventData)
                SetMetadataType(videoMetadata, videoPlayerKey, eventData.message.vtype)

                ' default state of video player is not looped
                ' it's set to looped only if applet calls play on the completed video
                ' in that case, video.resume() is called, instead of video.play() and looped status is changed to true
                isLooped = false

                if eventData.message.vtype = "video" then
                    videoFilePath = eventData.message.filePath
                    videoVolume = strtoi(eventData.message.volume)
                    PlayVideo(videoPlayer, videoFilePath, videoVolume)
                else if eventData.message.vtype = "stream" then
                    streamUri = eventData.message.uri
                    PlayStream(videoPlayer, streamUri)
                else if eventData.message.vtype = "hdmi" then
                    PlayHDMI(videoPlayer)
                end if

                SetMetadataInvocationUid(videoMetadata, videoPlayerKey, isLooped, eventData.message.invocationUid)
                defferedResponse = true
            end if
            if eventData.message.type = "video.get_duration" then
                videoPlayerKey = eventData.message.key
                videoPlayer = videoPlayers.Lookup(videoPlayerKey)
                response["duration"] = videoPlayer.GetDuration()
                response["succeeded"] = true
            end if
            if eventData.message.type = "video.stop" then
                videoPlayerKey = eventData.message.key
                videoPlayer = videoPlayers.Lookup(videoPlayerKey)
                videoPlayer.ClearEvents()
                SetMetadataStopped(videoMetadata, videoPlayerKey)
                SetVideoMetadataEnded(videoMetadata, videoPlayerKey, false)
                if eventData.message.clear = "1" then
                    videoPlayer.StopClear()
                else
                    videoPlayer.Stop()
                end if
                response["succeeded"] = true
            end if
            if eventData.message.type = "video.pause" then
                videoPlayerKey = eventData.message.key
                videoPlayer = videoPlayers.Lookup(videoPlayerKey)
                videoPosition = videoPlayer.GetPlaybackPosition()
                videoPlayer.Pause()
                SetMetadataInvocationUid(videoMetadata, videoPlayerKey, false, eventData.message.invocationUid)
                ' fake video event as BrightSign does not have native Pause code
                videoPlayer.AddEvent(2, videoPosition)
                defferedResponse = true
            end if
            if eventData.message.type = "video.resume" then
                videoPlayerKey = eventData.message.key
                videoPlayer = videoPlayers.Lookup(videoPlayerKey)
                videoDuration = videoPlayer.GetDuration()
                videoPosition = videoPlayer.GetPlaybackPosition()
                remainingTime = videoDuration - videoPosition
                isLooped = false

                ' If we play a single video loop, resume is called on video that is "almost" completed
                ' in that case, we need to turn on looping mode
                ' If we call resume on video that did not finish yet, we continue with playback
                if remainingTime < 1000 then
                    ' default state of video player is not looped
                    ' it's set to looped only if applet calls play on the completed video
                    ' in that case, video.resume() is called, and looped status is changed to true
                    isLooped = true
                    SetVideoMetadata(videoPlayers, videoMetadata, videoPlayerKey, isLooped)
                end if

                videoPlayer.Resume()
                response["succeeded"] = true
            end if
            if eventData.message.type = "monitors.get_list" then
                edidHdmiList = videoModeProvider.GetEdidIdentity(true)
                edidVgaList = videoModeProvider.GetEdidIdentity(false)
                list = CreateObject("roAssociativeArray")
                if not(edidHdmiList = invalid) then
                    list.hdmi = edidHdmiList
                end if
                if not(edidVgaList = invalid) then
                    list.vga = edidVgaList
                end if
                response["list"] = FormatJson(list, 1)
                response["succeeded"] = true
            end if
            if eventData.message.type = "system.device_info" then
                deviceInfo = CreateObject("roDeviceInfo")
                if eventData.message.infoType = "cpu" then
                    response["data"] = deviceInfo.GetLoadStatistics({item: "stat"})
                else if eventData.message.infoType = "memory" then
                    loadStatistics = deviceInfo.GetLoadStatistics({item: "meminfo"})
                    response["data"] = loadStatistics.Trim()
                else if eventData.message.infoType = "usb" then
                    usbTopology = deviceInfo.GetUSBTopology({rebuild: true})
                    response["data"] = usbTopology
                end if
                response["succeeded"] = true
            end if
            if eventData.message.type = "proxy.set_info" then
                networkInterfaceName = eventData.message.interface
                proxyUrl = eventData.message.proxyUrl
                networkInterface = CreateObject("roNetworkConfiguration", networkInterfaceName)
                if networkInterface <> invalid then
                    networkInterface.SetProxy(proxyUrl)
                    response["succeeded"] = networkInterface.Apply()
                else
                    response["succeeded"] = false
                end if
            end if
            if eventData.message.type = "hardware.serial_open_port" then
                device = eventData.message.device
                baudRate = StrToI(eventData.message.baudRate)
                mode = eventData.message.mode
                serialPort = CreateObject("roSerialPort", StrToI(device), baudRate)
                rtscts = LCase(eventData.message.rtscts) = "true"
                if serialPort <> Invalid then
                    supportsFlush = FindMemberFunction(serialPort, "Flush")
                    if supportsFlush <> Invalid then
                        response["flush"] = "Flush method supported: buffer successfully cleared."
                        serialPort.Flush()
                        sleep(1)
                    else
                        response["flush"] = "Flush method not supported: buffer could not be cleared."
                    end if
                    serialPort.SetByteEventPort(msgPort)
                    serialPort.SetBaudRate(baudRate)
                    supportsFlowControl = FindMemberFunction(serialPort, "setFlowControl")
                    if supportsFlowControl <> Invalid then
                        serialPort.setFlowControl(rtscts)
                        response["flowControl"] = "Flow control has been set."
                    else
                        response["flowControl"] = "Flow control is not supported."
                    end if
                    serialPort.SetMode(mode)
                    serialPorts.AddReplace(device, serialPort)
                    response["succeeded"] = true
                else
                    response["data"] = "Failed to open port"
                    response["succeeded"] = false
                end if
            end if
            if eventData.message.type = "hardware.serial_write_message" then
                device = eventData.message.device
                message = eventData.message.message
                serialPort = serialPorts.Lookup(device)
                if serialPort <> Invalid then
                    ' Even though there are three types of supported messages via serial port in the applet
                    ' (hexadecimal string, array of numbers and Uint8Array), the BrightScript handles both
                    ' array-like types in the same way, as a roAssociativeArray. That's why there are only two
                    ' types of messages handled here.
                    response["messageType"] = Type(message)
                    if Type(message) = "roString" then
                        serialPort.SendLine(message)
                        response["succeeded"] = true
                        response["message"] = message
                    else if Type(message) = "roAssociativeArray" then
                        ' The "FormatJson" is a workaround for the BrightScript limitation of not being able to send
                        ' nested associative arrays via the postJSMessage method.
                        ' https://brightsign.atlassian.net/wiki/spaces/DOC/pages/370672896/roHtmlWidget#PostJSMessage(data-As-roAssociativeArray)-As-Boolean
                        response["message"] = FormatJson(message, 1)
                        response["succeeded"] = true

                        ' It's not possible to obtain the length of the roAssociativeArray in BrightScript directly;
                        ' that's why we need to create a workaround to get the length of the associative array
                        index = 0
                        for each item in message
                            index = index + 1
                        end for

                        for i=0 to index - 1
                            msgType = Type(message[StrI(i).trim()])
                            value = message[StrI(i).trim()]
                            if msgType = "Integer" or msgType = "roInteger" then
                                serialPort.sendByte(value)
                            else if msgType = "roString" then
                                ' If the value is not of the correct type, convert it to an integer
                                serialPort.sendByte(Int(val(value)))
                            end if
                        end for
                    else
                        response["message"] = "The type of the message is not supported. Expected roString or roAssociativeArray."
                        response["succeeded"] = false
                    endif
                else
                    response["data"] = "Error, port not found"
                    response["succeeded"] = false
                end if
                response["device"] = device
            end if
            if eventData.message.type = "hardware.serial_close_port" then
                device = eventData.message.device
                serialPort = serialPorts.Lookup(device)
                if serialPort <> Invalid then
                    serialPort.Flush()
                    serialPorts.Delete(device)
                    response["succeeded"] = true
                else
                    response["data"] = "Failed to close serial port"
                    response["succeeded"] = false
                end if
            end if
            if eventData.message.type = "browser.open" then
                htmlPath = eventData.message.url
                x = eventData.message.x
                y = eventData.message.y
                width = eventData.message.width
                height = eventData.message.height

                if browserWidget <> invalid then
                    response["data"] = "One browser is already open"
                    response["succeeded"] = false
                else
                    browserWidget = SetupBrowserWidget(msgPort, screenRegistrySection, htmlPath, x, y, width, height, browserWindows)

                    ' we need time to let browserWidget fully initiate before we re-init the virtual keyboars again
                    ' if the sleep is not present the keyboard will not work with the new browserWidget and not allow inserting text
                    sleep(100)
                    SetupOnScreenKeyboard(msgPort, screenRegistrySection, onScreenKeyboardObject)
                    if browserWidget <> Invalid then
                        response["succeeded"] = true
                    else
                        response["data"] = "Unable to open browser"
                        response["succeeded"] = false
                    end if
                end if
            end if
            if eventData.message.type = "browser.close" then
                TerminateOnScreenKeyboard(onScreenKeyboardObject)
                browserWidget = DiscardBrowserWidget(browserWindows)
                if browserWidget <> Invalid then
                    response["succeeded"] = true
                else
                    response["data"] = "Unable to discard browser"
                    response["succeeded"] = false
                end if
            end if

            ' Send responses for synchronous events only
            if defferedResponse <> true then
                InvokeJSMessage(htmlWidget, eventData.message.invocationUid, response.succeeded, response)
            end if

            ' Handling brightscript garbage collector
            response = invalid

            ' BrightSign will be rebooted after sending response when the resolution changed
            if eventData.message.type = "screen.set_video_mode" AND response["succeeded"] = true then
                RebootSystem()
            end if
        end if
        if eventData.reason = "load-error" then
            print "message = ";eventData.message
        end if
    end if

    ' Set variables to invalid to allow garbage collection
    eventData = invalid
End Sub

Sub ProcessOnScreenKeyboardEvent(msg, onScreenKeyboardObject)
    onScreenKeyboard = onScreenKeyboardObject.Lookup("onScreenKeyboard")
    if onScreenKeyboard <> invalid then
        if msg.GetData().reason = "show-event" then
            onScreenKeyboard.show()
        end if
        if msg.GetData().reason = "hide-event" then
            onScreenKeyboard.hide()
        end if
    end if
End Sub

Sub TerminateOnScreenKeyboard(onScreenKeyboardObject)
    onScreenKeyboard = onScreenKeyboardObject.Lookup("onScreenKeyboard")
    if onScreenKeyboard <> invalid then
        onScreenKeyboard.hide()
    end if
End Sub
