LIBRARY "custom.brs"
LIBRARY "cloudControl_helpers.brs"
LIBRARY "coreApp_helpers.brs"
LIBRARY "eventLoop.brs"

Sub Main()
    print "Main sub begin"

    ' Elementary objects
    msgPort = CreateObject("roMessagePort")
    systemTime = CreateObject("roSystemTime")
    videoPlayers = CreateObject("roAssociativeArray")
    videoMetadata = CreateObject("roAssociativeArray")
    serialPorts = CreateObject("roAssociativeArray")
    screenRegistrySection = CreateObject("roRegistrySection", "screen")

    browserWindows = CreateObject("roAssociativeArray")
    onScreenKeyboardObject = CreateObject("roAssociativeArray")

    ' First start, including OnFirstTimeHook() of custom.brs
    FirstRunSetup(systemTime)

    ' Multiprocess of Chromium to cooperate with BrightScript
    ' See https://github.com/brightsign/bs-asset-fetcher/issues/1
    registrySection = CreateObject("roRegistrySection", "html")
    multiProcess = registrySection.read("mp")
    if multiProcess <> "1" then
        registrySection.write("mp","1")
        registrySection.flush()
        RebootSystem()
    endif

    ' Setups
    SetupAudio()
    debugRegistrySection = SetupDebug()
    videoModeProvider = SetupVideoMode()
    supportedVideoModes = GetSupportedVideoModes(videoModeProvider)
    fullScreenRectangle = SetupVideoCanvasAndResolution(videoModeProvider, screenRegistrySection, supportedVideoModes)
    htmlWidget = SetupHtmlWidget(msgPort, screenRegistrySection, fullScreenRectangle, debugRegistrySection, "index.html", "", browserWindows)
    SetupOnScreenKeyboard(msgPort, screenRegistrySection, onScreenKeyboardObject)
    ' Specific features can be disabled by commenting below
    EnableTouchScreen(msgPort, screenRegistrySection)

    ' Hook to custom.brs
    OnEveryStartHook()

    while true
        msg = Wait(0, msgPort)
        if type(msg) = "roVirtualKeyboardEvent" then
            print "roVirtualKeyboardEvent"
            ProcessOnScreenKeyboardEvent(msg, onScreenKeyboardObject)
        else if type(msg) = "roHtmlWidgetEvent" then
            ProcessHtmlWidgetEvent(msg, msgPort, browserWindows, videoModeProvider, supportedVideoModes, systemTime, screenRegistrySection, videoPlayers, videoMetadata, serialPorts, onScreenKeyboardObject)
        else if type(msg) = "roTouchEvent" then
            ProcessTouchEvent(msg, browserWindows, screenRegistrySection)
        else if type(msg) = "roVideoEvent" then
            ProcessVideoEvent(msg, htmlWidget, videoPlayers, videoMetadata)
        else if type(msg) = "roStreamLineEvent" then
            ProcessHardwareEvent(msg.GetString(), htmlWidget, serialPorts)
        else if type(msg) = "roStreamByteEvent" then
            ProcessHardwareEvent(msg.GetInt(), htmlWidget, serialPorts)
        endif
    end while

End Sub
